"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const fs_1 = require("fs");
const formatMessage = (message) => message
    .replace(/&/g, '&amp;')
    .replace(/</g, '&lt;')
    .replace(/>/g, '&gt;')
    .replace(/"/g, '&quot;')
    .replace(/'/g, '&#039;');
const htmlFormatter = function (formatter) {
    formatter.on('end', (event) => {
        let fileContent = '<!DOCTYPE html>\n';
        fileContent += '<html lang="en">\n';
        fileContent += '<head>\n';
        fileContent += '<meta charset="utf-8">\n';
        fileContent +=
            '<meta name="viewport" content="width=device-width, initial-scale=1">\n';
        fileContent += '<title>HTML Hint Violation Report</title>\n';
        fileContent += '<meta name="generator" content="HTMLHint">\n';
        fileContent += '<meta name="color-scheme" content="light dark">\n';
        fileContent +=
            '<meta name="description" content="HTMLHint Violation Report">\n';
        fileContent +=
            '<style>body{font-family:Arial,helvetica,sans-serif;} footer{margin-top:20px;text-align:center;opacity:0.5;}</style>\n';
        fileContent +=
            '<style>table{border-collapse:collapse;width:100%;} th,td{border:1px solid rgb(128,128,128,0.4);padding:8px;text-align:left;} th{background-color:rgb(128,128,128,0.2);}</style>\n';
        fileContent +=
            '<style>@media (prefers-color-scheme: dark) {body {background-color:#333;color-scheme: dark;color:#fff;}}</style>\n';
        fileContent += '</head>\n';
        fileContent += '<body>\n';
        fileContent += '<h1>Violation Report</h1>\n';
        fileContent += '<main>\n';
        fileContent += '<table>\n';
        fileContent +=
            '<tr><th>Number#</th><th>File Name</th><th>Line Number</th><th>Message</th></tr>\n';
        let totalMessages = 0;
        for (const { messages } of event.arrAllMessages) {
            totalMessages += messages.length;
        }
        let messageCount = 0;
        for (const { file, messages } of event.arrAllMessages) {
            messages.forEach(({ line, message }) => {
                messageCount++;
                const isLastMessage = messageCount === totalMessages;
                if (isLastMessage) {
                    fileContent += `<tr><td>${messageCount}</td><td>${file}</td><td>${line}</td><td>${formatMessage(message)}</td></tr></table>\n`;
                }
                else {
                    fileContent += `<tr><td>${messageCount}</td><td>${file}</td><td>${line}</td><td>${formatMessage(message)}</td></tr>\n`;
                }
            });
        }
        fileContent +=
            '<footer><small>Generated by <a href="https://htmlhint.com" target="_blank" rel="noopener">HTMLHint</a></small></footer>\n';
        fileContent += '</main>\n';
        fileContent += '</body>\n';
        fileContent += '</html>';
        console.log(fileContent);
        (0, fs_1.writeFileSync)('report.html', fileContent);
    });
};
module.exports = htmlFormatter;
//# sourceMappingURL=data:application/json;base64,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