/*!
 * HTMLHint v1.8.0
 * https://htmlhint.com
 * Built on: 2025-12-17
 * Copyright (c) 2025 HTMLHint
 * Licensed under MIT License
 */
!function(e,t){"object"==typeof exports&&"undefined"!=typeof module?module.exports=t():"function"==typeof define&&define.amd?define(t):(e="undefined"!=typeof globalThis?globalThis:e||self).HTMLHint=t()}(this,(function(){"use strict";function e(e){return e&&e.__esModule&&Object.prototype.hasOwnProperty.call(e,"default")?e.default:e}var t,a={},r={};var n,i={};var s,l={},o={};var u,d={};var c,f={};var m,h={};var p,g={};var b,v={};var y,w={};var L,O={};var P,_={};var j,x={};var M,T={};var C,A={};var $,N={};var k,q={};var R,E={};var D,S={};var z,U={};var H,Z={};var I,V={};var F,W={};var B,Y={};var J,Q={};var X,G={};var K,ee={};var te,ae={};var re,ne={};var ie,se={};function le(){return ie||(ie=1,Object.defineProperty(se,"__esModule",{value:!0}),se.default={id:"input-requires-label",description:"All [ input ] tags must have a corresponding [ label ] tag. ",init(e,t){const a=[],r=[];e.addListener("tagstart",(t=>{const n=t.tagName.toLowerCase(),i=e.getMapAttrs(t.attrs),s=t.col+n.length+1;"input"===n&&"hidden"!==i.type&&r.push({event:t,col:s,id:i.id}),"label"===n&&"for"in i&&""!==i.for&&a.push({event:t,col:s,forValue:i.for})})),e.addListener("end",(()=>{r.forEach((e=>{(function(e){let t=!1;return a.forEach((a=>{e.id&&e.id===a.forValue&&(t=!0)})),t})(e)||t.warn("No matching [ label ] tag found.",e.event.line,e.col,this,e.event.raw)}))}))}}),se}var oe,ue={};var de,ce={};var fe,me={};var he,pe={};var ge,be={};var ve,ye={};var we,Le={};var Oe,Pe={};var _e,je={};var xe,Me={};var Te,Ce={};var Ae,$e={};var Ne,ke={};var qe,Re={};var Ee,De={};var Se,ze={};var Ue,He,Ze,Ie={};function Ve(){return He||(He=1,function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.titleRequire=e.tagSelfClose=e.tagsCheck=e.tagPair=e.tagnameSpecialChars=e.tagnameLowercase=e.tagNoObsolete=e.styleDisabled=e.srcNotEmpty=e.specCharEscape=e.spaceTabMixedDisabled=e.scriptDisabled=e.metaViewportRequire=e.metaDescriptionRequire=e.metaCharsetRequire=e.mainRequire=e.linkRelCanonicalRequire=e.inputRequiresLabel=e.inlineStyleDisabled=e.inlineScriptDisabled=e.idUnique=e.idClassValue=e.idClassAdDisabled=e.htmlLangRequire=e.hrefAbsOrRel=e.headScriptDisabled=e.h1Require=e.frameTitleRequire=e.formMethodRequire=e.emptyTagNotSelfClosed=e.doctypeHTML5=e.doctypeFirst=e.buttonTypeRequire=e.attrWhitespace=e.attrValueSingleQuotes=e.attrValueNotEmpty=e.attrValueDoubleQuotes=e.attrUnsafeChars=e.attrSort=e.attrValueNoDuplication=e.attrNoUnnecessaryWhitespace=e.attrNoDuplication=e.attrLowercase=e.altRequire=void 0;var t=(s||(s=1,Object.defineProperty(o,"__esModule",{value:!0}),o.default={id:"alt-require",description:"The alt attribute of an <img> element must be present and alt attribute of area[href] and input[type=image] must have a value.",init(e,t){e.addListener("tagstart",(a=>{const r=a.tagName.toLowerCase(),n=e.getMapAttrs(a.attrs),i=a.col+r.length+1;let s;"img"!==r||"alt"in n?("area"===r&&"href"in n||"input"===r&&"image"===n.type)&&("alt"in n&&""!==n.alt||(s="area"===r?"area[href]":"input[type=image]",t.warn(`The alt attribute of ${s} must have a value.`,a.line,i,this,a.raw))):t.warn("An alt attribute must be present on <img> elements.",a.line,i,this,a.raw)}))}}),o);Object.defineProperty(e,"altRequire",{enumerable:!0,get:function(){return t.default}});var a=function(){if(u)return d;u=1,Object.defineProperty(d,"__esModule",{value:!0});const e=["allowReorder","attributeName","attributeType","autoReverse","baseFrequency","baseProfile","calcMode","clipPath","clipPathUnits","contentScriptType","contentStyleType","diffuseConstant","edgeMode","externalResourcesRequired","filterRes","filterUnits","glyphRef","gradientTransform","gradientUnits","kernelMatrix","kernelUnitLength","keyPoints","keySplines","keyTimes","lengthAdjust","limitingConeAngle","markerHeight","markerUnits","markerWidth","maskContentUnits","maskUnits","numOctaves","onBlur","onChange","onClick","onFocus","onKeyUp","onLoad","pathLength","patternContentUnits","patternTransform","patternUnits","pointsAtX","pointsAtY","pointsAtZ","preserveAlpha","preserveAspectRatio","primitiveUnits","refX","refY","repeatCount","repeatDur","requiredExtensions","requiredFeatures","specularConstant","specularExponent","spreadMethod","startOffset","stdDeviation","stitchTiles","surfaceScale","systemLanguage","tableValues","targetX","targetY","textLength","viewBox","viewTarget","xChannelSelector","yChannelSelector","zoomAndPan"];function t(e,t){if(t instanceof RegExp)return!!t.test(e)&&{match:e,pattern:t};const a=t[0],r=t[t.length-1],n=t[t.length-2],i="/"===a&&("/"===r||"/"===n&&"i"===r);return i?i&&"i"===r?new RegExp(t.slice(1,-2),"i").test(e):new RegExp(t.slice(1,-1)).test(e):e===t}return d.default={id:"attr-lowercase",description:"All attribute names must be in lowercase.",init(a,r,n){const i=(Array.isArray(n)?n:[]).concat(e);a.addListener("tagstart",(e=>{const a=e.attrs;let n;const s=e.col+e.tagName.length+1;for(let l=0,o=a.length;l<o;l++){n=a[l];const o=n.name;i.find((e=>t(o,e)))||o===o.toLowerCase()||r.error(`The attribute name of [ ${o} ] must be in lowercase.`,e.line,s+n.index,this,n.raw)}}))}},d}();Object.defineProperty(e,"attrLowercase",{enumerable:!0,get:function(){return a.default}});var r=(c||(c=1,Object.defineProperty(f,"__esModule",{value:!0}),f.default={id:"attr-no-duplication",description:"Elements cannot have duplicate attributes.",init(e,t){e.addListener("tagstart",(e=>{const a=e.attrs;let r,n;const i=e.col+e.tagName.length+1,s={};for(let l=0,o=a.length;l<o;l++)r=a[l],n=r.name,!0===s[n]&&t.error(`Duplicate of attribute name [ ${r.name} ] was found.`,e.line,i+r.index,this,r.raw),s[n]=!0}))}}),f);Object.defineProperty(e,"attrNoDuplication",{enumerable:!0,get:function(){return r.default}});var n=(m||(m=1,Object.defineProperty(h,"__esModule",{value:!0}),h.default={id:"attr-no-unnecessary-whitespace",description:"No spaces between attribute names and values.",init(e,t,a){const r=Array.isArray(a)?a:[];e.addListener("tagstart",(e=>{const a=e.attrs,n=e.col+e.tagName.length+1;for(let i=0;i<a.length;i++)if(-1===r.indexOf(a[i].name)){const r=/(\s*)=(\s*)/.exec(a[i].raw.trim());!r||0===r[1].length&&0===r[2].length||t.error(`The attribute '${a[i].name}' must not have spaces between the name and value.`,e.line,n+a[i].index,this,a[i].raw)}}))}}),h);Object.defineProperty(e,"attrNoUnnecessaryWhitespace",{enumerable:!0,get:function(){return n.default}});var i=(p||(p=1,Object.defineProperty(g,"__esModule",{value:!0}),g.default={id:"attr-value-no-duplication",description:"Class attributes should not contain duplicate values. Other attributes can be checked via configuration.",init(e,t,a){const r=Array.isArray(a)?a:["class"];e.addListener("tagstart",(e=>{const a=e.attrs;let n;const i=e.col+e.tagName.length+1;for(let s=0,l=a.length;s<l;s++){n=a[s];const l=n.name.toLowerCase();if(!r.includes(l))continue;if(!n.value||!/\s/.test(n.value))continue;const o=n.value.trim().split(/\s+/),u={};for(const a of o){if(a&&!0===u[a]){t.error(`Duplicate value [ ${a} ] was found in attribute [ ${n.name} ].`,e.line,i+n.index,this,n.raw);break}u[a]=!0}}}))}}),g);Object.defineProperty(e,"attrValueNoDuplication",{enumerable:!0,get:function(){return i.default}});var l=(b||(b=1,Object.defineProperty(v,"__esModule",{value:!0}),v.default={id:"attr-sorted",description:"Attribute tags must be in proper order.",init(e,t){const a={},r=["class","id","name","src","for","type","rel","href","value","title","alt","role"];for(let e=0;e<r.length;e++)a[r[e]]=e;e.addListener("tagstart",(e=>{const r=e.attrs,n=[];for(let e=0;e<r.length;e++)n.push(r[e].name);const i=JSON.stringify(n);n.sort(((e,t)=>void 0!==a[e]?void 0!==a[t]?a[e]-a[t]:-1:e.startsWith("data-")?t.startsWith("data-")?e.localeCompare(t):1:void 0!==a[t]?1:t.startsWith("data-")?-1:e.localeCompare(t))),i!==JSON.stringify(n)&&t.error(`Inaccurate order ${i} should be in hierarchy ${JSON.stringify(n)} `,e.line,e.col,this,e.raw)}))}}),v);Object.defineProperty(e,"attrSort",{enumerable:!0,get:function(){return l.default}});var ie=(y||(y=1,Object.defineProperty(w,"__esModule",{value:!0}),w.default={id:"attr-unsafe-chars",description:"Attribute values cannot contain unsafe chars.",init(e,t){e.addListener("tagstart",(e=>{const a=e.attrs;let r;const n=e.col+e.tagName.length+1,i=/[\u0000-\u0008\u000b\u000c\u000e-\u001f\u007f-\u009f\u00ad\u0600-\u0604\u070f\u17b4\u17b5\u200c-\u200f\u2028-\u202f\u2060-\u206f\ufeff\ufff0-\uffff]/;let s;for(let l=0,o=a.length;l<o;l++)if(r=a[l],s=i.exec(r.value),null!==s){const a=escape(s[0]).replace(/%u/,"\\u").replace(/%/,"\\x");t.warn(`The value of attribute [ ${r.name} ] cannot contain an unsafe char [ ${a} ].`,e.line,n+r.index,this,r.raw)}}))}}),w);Object.defineProperty(e,"attrUnsafeChars",{enumerable:!0,get:function(){return ie.default}});var se=(L||(L=1,Object.defineProperty(O,"__esModule",{value:!0}),O.default={id:"attr-value-double-quotes",description:"Attribute values must be in double quotes.",init(e,t){e.addListener("tagstart",(e=>{const a=e.attrs;let r;const n=e.col+e.tagName.length+1;for(let i=0,s=a.length;i<s;i++)r=a[i],(""!==r.value&&'"'!==r.quote||""===r.value&&"'"===r.quote)&&t.error(`The value of attribute [ ${r.name} ] must be in double quotes.`,e.line,n+r.index,this,r.raw)}))}}),O);Object.defineProperty(e,"attrValueDoubleQuotes",{enumerable:!0,get:function(){return se.default}});var He=(P||(P=1,Object.defineProperty(_,"__esModule",{value:!0}),_.default={id:"attr-value-not-empty",description:"All attributes must have values.",init(e,t){e.addListener("tagstart",(e=>{const a=e.attrs;let r;const n=e.col+e.tagName.length+1;for(let i=0,s=a.length;i<s;i++)r=a[i],""===r.quote&&""===r.value&&t.warn(`The attribute [ ${r.name} ] must have a value.`,e.line,n+r.index,this,r.raw)}))}}),_);Object.defineProperty(e,"attrValueNotEmpty",{enumerable:!0,get:function(){return He.default}});var Ze=(j||(j=1,Object.defineProperty(x,"__esModule",{value:!0}),x.default={id:"attr-value-single-quotes",description:"Attribute values must be in single quotes.",init(e,t){e.addListener("tagstart",(e=>{const a=e.attrs;let r;const n=e.col+e.tagName.length+1;for(let i=0,s=a.length;i<s;i++)r=a[i],(""!==r.value&&"'"!==r.quote||""===r.value&&'"'===r.quote)&&t.error(`The value of attribute [ ${r.name} ] must be in single quotes.`,e.line,n+r.index,this,r.raw)}))}}),x);Object.defineProperty(e,"attrValueSingleQuotes",{enumerable:!0,get:function(){return Ze.default}});var Ve=(M||(M=1,Object.defineProperty(T,"__esModule",{value:!0}),T.default={id:"attr-whitespace",description:"All attributes should be separated by only one space and not have leading/trailing whitespace.",init(e,t,a){const r=Array.isArray(a)?a:[];e.addListener("tagstart",(e=>{const a=e.attrs;let n;const i=e.col+e.tagName.length+1;a.forEach((a=>{n=a;const s=a.name;-1===r.indexOf(s)&&(a.value.trim()!==a.value&&t.error(`The attributes of [ ${s} ] must not have leading or trailing whitespace.`,e.line,i+n.index,this,n.raw),a.value.replace(/ +(?= )/g,"")!==a.value&&t.error(`The attributes of [ ${s} ] must be separated by only one space.`,e.line,i+n.index,this,n.raw))}))}))}}),T);Object.defineProperty(e,"attrWhitespace",{enumerable:!0,get:function(){return Ve.default}});var Fe=(C||(C=1,Object.defineProperty(A,"__esModule",{value:!0}),A.default={id:"button-type-require",description:'The type attribute of a <button> element must be present with a valid value: "button", "submit", or "reset".',init(e,t){e.addListener("tagstart",(a=>{const r=a.tagName.toLowerCase();if("button"===r){const n=e.getMapAttrs(a.attrs),i=a.col+r.length+1;if(void 0===n.type)t.warn("The type attribute must be present on <button> elements.",a.line,i,this,a.raw);else{const e=n.type.toLowerCase();"button"!==e&&"submit"!==e&&"reset"!==e&&t.warn('The type attribute of <button> must have a valid value: "button", "submit", or "reset".',a.line,i,this,a.raw)}}}))}}),A);Object.defineProperty(e,"buttonTypeRequire",{enumerable:!0,get:function(){return Fe.default}});var We=($||($=1,Object.defineProperty(N,"__esModule",{value:!0}),N.default={id:"doctype-first",description:"Doctype must be declared first (comments and whitespace allowed before DOCTYPE).",init(e,t){let a=!1,r=!1;const n=i=>{if(!("start"===i.type||"text"===i.type&&/^\s*$/.test(i.raw)||a))return"comment"===i.type&&!1===i.long&&/^DOCTYPE\s+/i.test(i.content)?(a=!0,void(r&&t.error("Doctype must be declared before any non-comment content.",i.line,i.col,this,i.raw))):void("comment"!==i.type&&(r=!0,t.error("Doctype must be declared before any non-comment content.",i.line,i.col,this,i.raw),e.removeListener("all",n)))};e.addListener("all",n)}}),N);Object.defineProperty(e,"doctypeFirst",{enumerable:!0,get:function(){return We.default}});var Be=(k||(k=1,Object.defineProperty(q,"__esModule",{value:!0}),q.default={id:"doctype-html5",description:'Invalid doctype. Use: "<!DOCTYPE html>"',init(e,t){const a=e=>{!1===e.long&&"doctype html"!==e.content.toLowerCase()&&t.warn('Invalid doctype. Use: "<!DOCTYPE html>"',e.line,e.col,this,e.raw)},r=()=>{e.removeListener("comment",a),e.removeListener("tagstart",r)};e.addListener("all",a),e.addListener("tagstart",r)}}),q);Object.defineProperty(e,"doctypeHTML5",{enumerable:!0,get:function(){return Be.default}});var Ye=(R||(R=1,Object.defineProperty(E,"__esModule",{value:!0}),E.default={id:"empty-tag-not-self-closed",description:"Empty tags must not use self closed syntax.",init(e,t){const a=e.makeMap("area,base,basefont,bgsound,br,col,frame,hr,img,input,isindex,link,meta,param,embed,track,command,source,keygen,wbr");e.addListener("tagstart",(e=>{const r=e.tagName.toLowerCase();void 0!==a[r]&&e.close&&t.error(`The empty tag : [ ${r} ] must not use self closed syntax.`,e.line,e.col,this,e.raw)}))}}),E);Object.defineProperty(e,"emptyTagNotSelfClosed",{enumerable:!0,get:function(){return Ye.default}});var Je=(D||(D=1,Object.defineProperty(S,"__esModule",{value:!0}),S.default={id:"form-method-require",description:'The method attribute of a <form> element must be present with a valid value: "get", "post", or "dialog".',init(e,t){e.addListener("tagstart",(a=>{const r=a.tagName.toLowerCase();if("form"===r){const n=e.getMapAttrs(a.attrs),i=a.col+r.length+1;if(void 0===n.method)t.warn("The method attribute must be present on <form> elements.",a.line,i,this,a.raw);else{const e=n.method.toLowerCase();"get"!==e&&"post"!==e&&"dialog"!==e&&t.warn('The method attribute of <form> must have a valid value: "get", "post", or "dialog".',a.line,i,this,a.raw)}}}))}}),S);Object.defineProperty(e,"formMethodRequire",{enumerable:!0,get:function(){return Je.default}});var Qe=(z||(z=1,Object.defineProperty(U,"__esModule",{value:!0}),U.default={id:"frame-title-require",description:"A <frame> or <iframe> element must have an accessible name.",init(e,t){e.addListener("tagstart",(a=>{const r=a.tagName.toLowerCase(),n=e.getMapAttrs(a.attrs),i=a.col+r.length+1;if("frame"===r||"iframe"===r){const e=n.role;if("presentation"===e||"none"===e)return;const s="aria-label"in n&&""!==n["aria-label"].trim(),l="aria-labelledby"in n&&""!==n["aria-labelledby"].trim(),o="title"in n&&""!==n.title.trim();s||l||o||t.warn(`A <${r}> element must have an accessible name.`,a.line,i,this,a.raw)}}))}}),U);Object.defineProperty(e,"frameTitleRequire",{enumerable:!0,get:function(){return Qe.default}});var Xe=(H||(H=1,Object.defineProperty(Z,"__esModule",{value:!0}),Z.default={id:"h1-require",description:"<h1> must be present in <body> tag and not be empty.",init(e,t){let a=0,r=!1,n=null,i=null,s=!1;e.addListener("tagstart",(e=>{const t=e.tagName.toLowerCase();"body"===t?(a++,1===a&&(r=!1,n=e)):"h1"===t&&a>0&&(r=!0,i=e,s=!0)})),e.addListener("tagend",(e=>{const l=e.tagName.toLowerCase();"h1"===l&&i?(s&&t.warn("<h1> tag must not be empty.",i.line,i.col,this,i.raw),i=null):"body"===l&&(1===a&&!r&&n&&t.warn("<h1> must be present in <body> tag.",n.line,n.col,this,n.raw),a--,a<0&&(a=0))})),e.addListener("text",(e=>{i&&s&&e.raw&&!/^\s*$/.test(e.raw)&&(s=!1)})),e.addListener("end",(()=>{a>0&&!r&&n&&t.warn("<h1> must be present in <body> tag.",n.line,n.col,this,n.raw)}))}}),Z);Object.defineProperty(e,"h1Require",{enumerable:!0,get:function(){return Xe.default}});var Ge=(I||(I=1,Object.defineProperty(V,"__esModule",{value:!0}),V.default={id:"head-script-disabled",description:"The <script> tag cannot be used in a <head> tag.",init(e,t,a){const r=/^(text\/javascript|application\/javascript)$/i;let n=!1;const i=i=>{const s=e.getMapAttrs(i.attrs),l=s.type,o=s.defer,u=i.tagName.toLowerCase();if("head"===u&&(n=!0),!0===n&&"script"===u){const e="module"===l,n=void 0!==o,u=void 0!==s.async;(!l||!0===r.test(l)||e)&&("allow-non-blocking"===a?e||n||u||t.warn('The <script> tag cannot be used in a <head> tag unless it has type="module", defer, or async attribute.',i.line,i.col,this,i.raw):t.warn("The <script> tag cannot be used in a <head> tag.",i.line,i.col,this,i.raw))}},s=t=>{"head"===t.tagName.toLowerCase()&&(e.removeListener("tagstart",i),e.removeListener("tagend",s))};e.addListener("tagstart",i),e.addListener("tagend",s)}}),V);Object.defineProperty(e,"headScriptDisabled",{enumerable:!0,get:function(){return Ge.default}});var Ke=(F||(F=1,Object.defineProperty(W,"__esModule",{value:!0}),W.default={id:"href-abs-or-rel",description:"An href attribute must be either absolute or relative.",init(e,t,a){const r="abs"===a?"absolute":"relative";e.addListener("tagstart",(e=>{const a=e.attrs;let n;const i=e.col+e.tagName.length+1;for(let s=0,l=a.length;s<l;s++)if(n=a[s],"href"===n.name){("absolute"===r&&!1===/^\w+?:/.test(n.value)||"relative"===r&&!0===/^https?:\/\//.test(n.value))&&t.warn(`The value of the href attribute [ ${n.value} ] must be ${r}.`,e.line,i+n.index,this,n.raw);break}}))}}),W);Object.defineProperty(e,"hrefAbsOrRel",{enumerable:!0,get:function(){return Ke.default}});var et=(B||(B=1,Object.defineProperty(Y,"__esModule",{value:!0}),Y.default={id:"html-lang-require",description:"The lang attribute of an <html> element must be present and should be valid.",init(e,t){e.addListener("tagstart",(a=>{const r=a.tagName.toLowerCase(),n=e.getMapAttrs(a.attrs),i=a.col+r.length+1,s=new RegExp("((?<grandfathered>(en-GB-oed|i-ami|i-bnn|i-default|i-enochian|i-hak|i-klingon|i-lux|i-mingo|i-navajo|i-pwn|i-tao|i-tay|i-tsu|sgn-BE-FR|sgn-BE-NL|sgn-CH-DE)|(art-lojban|cel-gaulish|no-bok|no-nyn|zh-guoyu|zh-hakka|zh-min|zh-min-nan|zh-xiang))|((?<language>([A-Za-z]{2,3}(-(?<extlang>[A-Za-z]{3}(-[A-Za-z]{3}){0,2}))?)|[A-Za-z]{4}|[A-Za-z]{5,8})(-(?<script>[A-Za-z]{4}))?(-(?<region>[A-Za-z]{2}|[0-9]{3}))?(-(?<variant>[A-Za-z0-9]{5,8}|[0-9][A-Za-z0-9]{3}))*(-(?<extension>[0-9A-WY-Za-wy-z](-[A-Za-z0-9]{2,8})+))*(-(?<privateUse>x(-[A-Za-z0-9]{1,8})+))?)|(?<privateUse2>x(-[A-Za-z0-9]{1,8})+))","g");"html"===r&&("lang"in n?n.lang?s.test(n.lang)||t.warn("The lang attribute value of <html> element must be a valid BCP47.",a.line,i,this,a.raw):t.warn("The lang attribute of <html> element must have a value.",a.line,i,this,a.raw):t.warn("An lang attribute must be present on <html> elements.",a.line,i,this,a.raw))}))}}),Y);Object.defineProperty(e,"htmlLangRequire",{enumerable:!0,get:function(){return et.default}});var tt=(J||(J=1,Object.defineProperty(Q,"__esModule",{value:!0}),Q.default={id:"id-class-ad-disabled",description:"The id and class attributes cannot use the ad keyword, it will be blocked by adblock software.",init(e,t){e.addListener("tagstart",(e=>{const a=e.attrs;let r,n;const i=e.col+e.tagName.length+1;for(let s=0,l=a.length;s<l;s++)r=a[s],n=r.name,/^(id|class)$/i.test(n)&&/(^|[-_])ad([-_]|$)/i.test(r.value)&&t.warn(`The value of attribute ${n} cannot use the ad keyword.`,e.line,i+r.index,this,r.raw)}))}}),Q);Object.defineProperty(e,"idClassAdDisabled",{enumerable:!0,get:function(){return tt.default}});var at=(X||(X=1,Object.defineProperty(G,"__esModule",{value:!0}),G.default={id:"id-class-value",description:"The id and class attribute values must meet the specified rules.",init(e,t,a){let r;if(r="string"==typeof a?{underline:{regId:/^[a-z\d]+(_[a-z\d]+)*$/,message:"The id and class attribute values must be in lowercase and split by an underscore."},dash:{regId:/^[a-z\d]+(-[a-z\d]+)*$/,message:"The id and class attribute values must be in lowercase and split by a dash."},hump:{regId:/^[a-z][a-zA-Z\d]*([A-Z][a-zA-Z\d]*)*$/,message:"The id and class attribute values must meet the camelCase style."}}[a]:a,"object"==typeof r&&r.regId){let a=r.regId;const n=r.message;a instanceof RegExp||(a=new RegExp(a)),e.addListener("tagstart",(e=>{const r=e.attrs;let i;const s=e.col+e.tagName.length+1;for(let l=0,o=r.length;l<o;l++)if(i=r[l],"id"===i.name.toLowerCase()&&!1===a.test(i.value)&&t.warn(n,e.line,s+i.index,this,i.raw),"class"===i.name.toLowerCase()){const r=i.value.split(/\s+/g);let l;for(let o=0,u=r.length;o<u;o++)l=r[o],l&&!1===a.test(l)&&t.warn(n,e.line,s+i.index,this,l)}}))}}}),G);Object.defineProperty(e,"idClassValue",{enumerable:!0,get:function(){return at.default}});var rt=(K||(K=1,Object.defineProperty(ee,"__esModule",{value:!0}),ee.default={id:"id-unique",description:"The value of id attributes must be unique.",init(e,t){const a={};e.addListener("tagstart",(e=>{const r=e.attrs;let n,i;const s=e.col+e.tagName.length+1;for(let l=0,o=r.length;l<o;l++)if(n=r[l],"id"===n.name.toLowerCase()){i=n.value,i&&(void 0===a[i]?a[i]=1:a[i]++,a[i]>1&&t.error(`The id value [ ${i} ] must be unique.`,e.line,s+n.index,this,n.raw));break}}))}}),ee);Object.defineProperty(e,"idUnique",{enumerable:!0,get:function(){return rt.default}});var nt=(te||(te=1,Object.defineProperty(ae,"__esModule",{value:!0}),ae.default={id:"inline-script-disabled",description:"Inline script cannot be used.",init(e,t){e.addListener("tagstart",(e=>{const a=e.attrs;let r;const n=e.col+e.tagName.length+1;let i;const s=/^on(unload|message|submit|select|scroll|resize|mouseover|mouseout|mousemove|mouseleave|mouseenter|mousedown|load|keyup|keypress|keydown|focus|dblclick|click|change|blur|error)$/i;for(let l=0,o=a.length;l<o;l++)r=a[l],i=r.name.toLowerCase(),!0===s.test(i)?t.warn(`Inline script [ ${r.raw} ] cannot be used.`,e.line,n+r.index,this,r.raw):"src"!==i&&"href"!==i||/^\s*javascript:/i.test(r.value)&&t.warn(`Inline script [ ${r.raw} ] cannot be used.`,e.line,n+r.index,this,r.raw)}))}}),ae);Object.defineProperty(e,"inlineScriptDisabled",{enumerable:!0,get:function(){return nt.default}});var it=(re||(re=1,Object.defineProperty(ne,"__esModule",{value:!0}),ne.default={id:"inline-style-disabled",description:"Inline style cannot be used.",init(e,t){e.addListener("tagstart",(e=>{const a=e.attrs;let r;const n=e.col+e.tagName.length+1;for(let i=0,s=a.length;i<s;i++)r=a[i],"style"===r.name.toLowerCase()&&t.warn(`Inline style [ ${r.raw} ] cannot be used.`,e.line,n+r.index,this,r.raw)}))}}),ne);Object.defineProperty(e,"inlineStyleDisabled",{enumerable:!0,get:function(){return it.default}});var st=le();Object.defineProperty(e,"inputRequiresLabel",{enumerable:!0,get:function(){return st.default}});var lt=(oe||(oe=1,Object.defineProperty(ue,"__esModule",{value:!0}),ue.default={id:"link-rel-canonical-require",description:'<link rel="canonical"> with non-blank href must be present in <head> tag.',init(e,t){let a=!1,r=!1,n="",i=null;e.addListener("tagstart",(t=>{const s=t.tagName.toLowerCase();if("head"===s)a=!0,i=t;else if("link"===s){const a=e.getMapAttrs(t.attrs);a.rel&&"canonical"===a.rel.toLowerCase()&&(r=!0,n=a.href||"")}})),e.addListener("end",(()=>{a&&i&&(r?""===n.trim()&&t.error('<link rel="canonical"> href attribute must not be empty.',i.line,i.col,this,i.raw):t.error('<link rel="canonical"> must be present in <head> tag.',i.line,i.col,this,i.raw))}))}}),ue);Object.defineProperty(e,"linkRelCanonicalRequire",{enumerable:!0,get:function(){return lt.default}});var ot=(de||(de=1,Object.defineProperty(ce,"__esModule",{value:!0}),ce.default={id:"main-require",description:"<main> must be present in <body> tag.",init(e,t){let a=0,r=!1,n=null;e.addListener("tagstart",(e=>{const t=e.tagName.toLowerCase();"body"===t?(a++,1===a&&(r=!1,n=e)):"main"===t&&a>0&&(r=!0)})),e.addListener("tagend",(e=>{"body"===e.tagName.toLowerCase()&&(1===a&&!r&&n&&t.warn("<main> must be present in <body> tag.",n.line,n.col,this,n.raw),a--,a<0&&(a=0))})),e.addListener("end",(()=>{a>0&&!r&&n&&t.warn("<main> must be present in <body> tag.",n.line,n.col,this,n.raw)}))}}),ce);Object.defineProperty(e,"mainRequire",{enumerable:!0,get:function(){return ot.default}});var ut=(fe||(fe=1,Object.defineProperty(me,"__esModule",{value:!0}),me.default={id:"meta-charset-require",description:'<meta charset=""> must be present in <head> tag.',init(e,t){let a=!1,r=!1,n="",i=null;e.addListener("tagstart",(t=>{const s=t.tagName.toLowerCase();if("head"===s)a=!0,i=t;else if("meta"===s){const a=e.getMapAttrs(t.attrs);void 0!==a.charset&&(r=!0,n=a.charset||"")}})),e.addListener("end",(()=>{a&&i&&(r?""===n.trim()&&t.error('<meta charset=""> value must not be empty.',i.line,i.col,this,i.raw):t.error('<meta charset=""> must be present in <head> tag.',i.line,i.col,this,i.raw))}))}}),me);Object.defineProperty(e,"metaCharsetRequire",{enumerable:!0,get:function(){return ut.default}});var dt=(he||(he=1,Object.defineProperty(pe,"__esModule",{value:!0}),pe.default={id:"meta-description-require",description:'<meta name="description"> with non-blank content must be present in <head> tag.',init(e,t){let a=!1,r=!1,n="",i=null;e.addListener("tagstart",(t=>{const s=t.tagName.toLowerCase();if("head"===s)a=!0,i=t;else if("meta"===s){const a=e.getMapAttrs(t.attrs);a.name&&"description"===a.name.toLowerCase()&&(r=!0,n=a.content||"")}})),e.addListener("end",(()=>{a&&i&&(r?""===n.trim()&&t.error('<meta name="description"> content attribute must not be empty.',i.line,i.col,this,i.raw):t.error('<meta name="description"> must be present in <head> tag.',i.line,i.col,this,i.raw))}))}}),pe);Object.defineProperty(e,"metaDescriptionRequire",{enumerable:!0,get:function(){return dt.default}});var ct=(ge||(ge=1,Object.defineProperty(be,"__esModule",{value:!0}),be.default={id:"meta-viewport-require",description:'<meta name="viewport"> with non-blank content must be present in <head> tag.',init(e,t){let a=!1,r=!1,n="",i=null;e.addListener("tagstart",(t=>{const s=t.tagName.toLowerCase();if("head"===s)a=!0,i=t;else if("meta"===s){const a=e.getMapAttrs(t.attrs);a.name&&"viewport"===a.name.toLowerCase()&&(r=!0,n=a.content||"")}})),e.addListener("end",(()=>{a&&i&&(r?""===n.trim()&&t.error('<meta name="viewport"> content attribute must not be empty.',i.line,i.col,this,i.raw):t.error('<meta name="viewport"> must be present in <head> tag.',i.line,i.col,this,i.raw))}))}}),be);Object.defineProperty(e,"metaViewportRequire",{enumerable:!0,get:function(){return ct.default}});var ft=(ve||(ve=1,Object.defineProperty(ye,"__esModule",{value:!0}),ye.default={id:"script-disabled",description:"The <script> tag cannot be used.",init(e,t){e.addListener("tagstart",(e=>{"script"===e.tagName.toLowerCase()&&t.error("The <script> tag cannot be used.",e.line,e.col,this,e.raw)}))}}),ye);Object.defineProperty(e,"scriptDisabled",{enumerable:!0,get:function(){return ft.default}});var mt=(we||(we=1,Object.defineProperty(Le,"__esModule",{value:!0}),Le.default={id:"space-tab-mixed-disabled",description:"Do not mix tabs and spaces for indentation.",init(e,t,a){let r="nomix",n=null;if("string"==typeof a){const e=/^([a-z]+)(\d+)?/.exec(a);e&&(r=e[1],n=e[2]&&parseInt(e[2],10))}e.addListener("text",(a=>{const i=a.raw,s=/(^|\r?\n)([ \t]+)/g;let l;for(;l=s.exec(i);){const i=e.fixPos(a,l.index+l[1].length);if(1!==i.col)continue;const s=l[2];"space"===r?n?!1!==/^ +$/.test(s)&&s.length%n===0||t.warn(`Please use space for indentation and keep ${n} length.`,i.line,1,this,a.raw):!1===/^ +$/.test(s)&&t.warn("Please use space for indentation.",i.line,1,this,a.raw):"tab"===r&&!1===/^\t+$/.test(s)?t.warn("Please use tab for indentation.",i.line,1,this,a.raw):!0===/ +\t|\t+ /.test(s)&&t.warn("Do not mix tabs and spaces for indentation.",i.line,1,this,a.raw)}}))}}),Le);Object.defineProperty(e,"spaceTabMixedDisabled",{enumerable:!0,get:function(){return mt.default}});var ht=(Oe||(Oe=1,Object.defineProperty(Pe,"__esModule",{value:!0}),Pe.default={id:"spec-char-escape",description:"Special characters must be escaped.",init(e,t){e.addListener("text",(a=>{const r=a.raw,n=/([<>])/g;let i;for(;i=n.exec(r);){const r=e.fixPos(a,i.index);t.error(`Special characters must be escaped : [ ${i[0]} ].`,r.line,r.col,this,a.raw)}}))}}),Pe);Object.defineProperty(e,"specCharEscape",{enumerable:!0,get:function(){return ht.default}});var pt=(_e||(_e=1,Object.defineProperty(je,"__esModule",{value:!0}),je.default={id:"src-not-empty",description:"The src attribute of an img(script,link) must have a value.",init(e,t){e.addListener("tagstart",(e=>{const a=e.tagName,r=e.attrs;let n;const i=e.col+a.length+1;for(let s=0,l=r.length;s<l;s++)n=r[s],(!0===/^(img|script|embed|bgsound|iframe)$/.test(a)&&"src"===n.name||"link"===a&&"href"===n.name||"object"===a&&"data"===n.name)&&""===n.value&&t.error(`The attribute [ ${n.name} ] of the tag [ ${a} ] must have a value.`,e.line,i+n.index,this,n.raw)}))}}),je);Object.defineProperty(e,"srcNotEmpty",{enumerable:!0,get:function(){return pt.default}});var gt=(xe||(xe=1,Object.defineProperty(Me,"__esModule",{value:!0}),Me.default={id:"style-disabled",description:"<style> tags cannot be used.",init(e,t){e.addListener("tagstart",(e=>{"style"===e.tagName.toLowerCase()&&t.warn("The <style> tag cannot be used.",e.line,e.col,this,e.raw)}))}}),Me);Object.defineProperty(e,"styleDisabled",{enumerable:!0,get:function(){return gt.default}});var bt=function(){if(Te)return Ce;Te=1,Object.defineProperty(Ce,"__esModule",{value:!0});const e=["applet","acronym","bgsound","dir","frame","frameset","noframes","isindex","keygen","listing","menuitem","nextid","noembed","plaintext","rb","rtc","strike","xmp","basefont","big","blink","center","font","marquee","multicol","nobr","spacer","tt"];return Ce.default={id:"tag-no-obsolete",description:"Disallows the use of obsolete HTML tags.",init(t,a,r){t.addListener("tagstart,tagend",(t=>{const r=t.tagName.toLowerCase();e.includes(r)&&a.error(`The tag [ ${t.tagName} ] is obsolete in HTML5 and should not be used.`,t.line,t.col,this,t.raw)}))}},Ce}();Object.defineProperty(e,"tagNoObsolete",{enumerable:!0,get:function(){return bt.default}});var vt=(Ae||(Ae=1,Object.defineProperty($e,"__esModule",{value:!0}),$e.default={id:"tagname-lowercase",description:"All html element names must be in lowercase.",init(e,t,a){const r=Array.isArray(a)?a:[];e.addListener("tagstart,tagend",(e=>{const a=e.tagName;-1===r.indexOf(a)&&a!==a.toLowerCase()&&t.error(`The html element name of [ ${a} ] must be in lowercase.`,e.line,e.col,this,e.raw)}))}}),$e);Object.defineProperty(e,"tagnameLowercase",{enumerable:!0,get:function(){return vt.default}});var yt=(Ne||(Ne=1,Object.defineProperty(ke,"__esModule",{value:!0}),ke.default={id:"tagname-specialchars",description:"All special characters must be escaped.",init(e,t){const a=/[^a-zA-Z0-9\-:_]/;e.addListener("tagstart,tagend",(e=>{const r=e.tagName;a.test(r)&&t.error(`The html element name of [ ${r} ] contains special character.`,e.line,e.col,this,e.raw)}))}}),ke);Object.defineProperty(e,"tagnameSpecialChars",{enumerable:!0,get:function(){return yt.default}});var wt=(qe||(qe=1,Object.defineProperty(Re,"__esModule",{value:!0}),Re.default={id:"tag-pair",description:"Tag must be paired.",init(e,t){const a=[],r=e.makeMap("area,base,basefont,br,col,frame,hr,img,input,isindex,link,meta,param,embed,track,command,source,keygen,wbr");e.addListener("tagstart",(e=>{const t=e.tagName.toLowerCase();void 0!==r[t]||e.close||a.push({tagName:t,line:e.line,col:e.col,raw:e.raw})})),e.addListener("tagend",(e=>{const r=e.tagName.toLowerCase();let n;for(n=a.length-1;n>=0&&a[n].tagName!==r;n--);if(n>=0){const r=[];for(let e=a.length-1;e>n;e--)r.push(`</${a[e].tagName}>`);if(r.length>0){const n=a[a.length-1];t.error(`Tag must be paired, missing: [ ${r.join("")} ], start tag match failed [ ${n.raw} ] on line ${n.line}.`,n.line||e.line,n.col||e.col,this,e.raw)}a.length=n}else t.error(`Tag must be paired, no start tag: [ ${e.raw} ]`,e.line,e.col,this,e.raw)})),e.addListener("end",(e=>{const r=[];for(let e=a.length-1;e>=0;e--)r.push(`</${a[e].tagName}>`);if(r.length>0){const n=a[a.length-1];t.error(`Tag must be paired, missing: [ ${r.join("")} ], open tag match failed [ ${n.raw} ] on line ${n.line}.`,e.line,e.col,this,"")}}))}}),Re);Object.defineProperty(e,"tagPair",{enumerable:!0,get:function(){return wt.default}});var Lt=function(){if(Ee)return De;Ee=1,Object.defineProperty(De,"__esModule",{value:!0});let e={a:{selfclosing:!1,attrsRequired:["href","title"],redundantAttrs:["alt"]},div:{selfclosing:!1},main:{selfclosing:!1,redundantAttrs:["role"]},nav:{selfclosing:!1,redundantAttrs:["role"]},script:{attrsOptional:[["async","async"],["defer","defer"]]},img:{selfclosing:!0,attrsRequired:["src","alt","title"]}};return De.default={id:"tags-check",description:"Checks html tags.",init(t,a,r){e={...e,...r},t.addListener("tagstart",(t=>{const r=t.attrs,n=t.col+t.tagName.length+1,i=t.tagName.toLowerCase();if(e[i]){const s=e[i];!0!==s.selfclosing||t.close?!1===s.selfclosing&&t.close&&a.warn(`The <${i}> tag must not be selfclosing.`,t.line,t.col,this,t.raw):a.warn(`The <${i}> tag must be selfclosing.`,t.line,t.col,this,t.raw),Array.isArray(s.attrsRequired)&&s.attrsRequired.forEach((e=>{if(Array.isArray(e)){const s=e.map((e=>e)),l=s.shift(),o=s;r.some((e=>e.name===l))?r.forEach((e=>{e.name===l&&-1===o.indexOf(e.value)&&a.error(`The <${i}> tag must have attr '${l}' with one value of '${o.join("' or '")}'.`,t.line,n,this,t.raw)})):a.error(`The <${i}> tag must have attr '${l}'.`,t.line,n,this,t.raw)}else r.some((t=>-1!==e.split("|").indexOf(t.name)))||a.error(`The <${i}> tag must have attr '${e}'.`,t.line,n,this,t.raw)})),Array.isArray(s.attrsOptional)&&s.attrsOptional.forEach((e=>{if(Array.isArray(e)){const s=e.map((e=>e)),l=s.shift(),o=s;r.some((e=>e.name===l))&&r.forEach((e=>{e.name===l&&-1===o.indexOf(e.value)&&a.error(`The <${i}> tag must have optional attr '${l}' with one value of '${o.join("' or '")}'.`,t.line,n,this,t.raw)}))}})),Array.isArray(s.redundantAttrs)&&s.redundantAttrs.forEach((e=>{r.some((t=>t.name===e))&&a.error(`The attr '${e}' is redundant for <${i}> and should be omitted.`,t.line,n,this,t.raw)}))}}))}},De}();Object.defineProperty(e,"tagsCheck",{enumerable:!0,get:function(){return Lt.default}});var Ot=(Se||(Se=1,Object.defineProperty(ze,"__esModule",{value:!0}),ze.default={id:"tag-self-close",description:"Empty tags must be self closed.",init(e,t){const a=e.makeMap("area,base,basefont,bgsound,br,col,frame,hr,img,input,isindex,link,meta,param,embed,track,command,source,keygen,wbr");e.addListener("tagstart",(e=>{const r=e.tagName.toLowerCase();void 0!==a[r]&&(e.close||t.warn(`The empty tag : [ ${r} ] must be self closed.`,e.line,e.col,this,e.raw))}))}}),ze);Object.defineProperty(e,"tagSelfClose",{enumerable:!0,get:function(){return Ot.default}});var Pt=(Ue||(Ue=1,Object.defineProperty(Ie,"__esModule",{value:!0}),Ie.default={id:"title-require",description:"<title> must be present in <head> tag.",init(e,t){let a=!1,r=!1;const n=e=>{const t=e.tagName.toLowerCase();"head"===t?a=!0:"title"===t&&a&&(r=!0)},i=a=>{const s=a.tagName.toLowerCase();if(r&&"title"===s){const e=a.lastEvent;("text"!==e.type||"text"===e.type&&!0===/^\s*$/.test(e.raw))&&t.error("<title></title> must not be empty.",a.line,a.col,this,a.raw)}else"head"===s&&(!1===r&&t.error("<title> must be present in <head> tag.",a.line,a.col,this,a.raw),e.removeListener("tagstart",n),e.removeListener("tagend",i))};e.addListener("tagstart",n),e.addListener("tagend",i)}}),Ie);Object.defineProperty(e,"titleRequire",{enumerable:!0,get:function(){return Pt.default}})}(l)),l}var Fe=(Ze||(Ze=1,function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.HTMLParser=e.Reporter=e.HTMLRules=e.HTMLHint=void 0;const a=(t||(t=1,Object.defineProperty(r,"__esModule",{value:!0}),r.default=class{constructor(){this._listeners={},this._mapCdataTags=this.makeMap("script,style"),this._arrBlocks=[],this.lastEvent=null}makeMap(e){const t={},a=e.split(",");for(let e=0;e<a.length;e++)t[a[e]]=!0;return t}parse(e){const t=this._mapCdataTags,a=/<(?:\/([^\s>]+)\s*|!--([\s\S]*?)--|!([^>]*?)|([\w\-:]+)((?:\s+[^\s"'>\/=\x00-\x0F\x7F\x80-\x9F]+(?:\s*=\s*(?:"[^"]*"|'[^']*'|[^\s"'>]*))?)*?)\s*(\/?))>/g,r=/\s*([^\s"'>\/=\x00-\x0F\x7F\x80-\x9F]+)(?:\s*=\s*(?:(")([^"]*)"|(')([^']*)'|([^\s"'>]*)))?/g,n=/\r?\n/g;let i,s,l,o,u,d,c=0,f=null,m=[],h=0,p=0,g=1;const b=this._arrBlocks;this.fire("start",{pos:0,line:1,col:1});const v=()=>{const e=o.find((e=>"type"===e.name))||{value:""};return t[l]&&-1===e.value.indexOf("text/ng-template")},y=(e,t,a,r)=>{const i=a-p+1;for(void 0===r&&(r={}),r.raw=t,r.pos=a,r.line=g,r.col=i,b.push(r),this.fire(e,r);n.exec(t);)g++,p=a+n.lastIndex};for(;i=a.exec(e);)if(s=i.index,s>c&&(d=e.substring(c,s),f?m.push(d):y("text",d,c)),c=a.lastIndex,!(l=i[1])||(f&&l===f&&(d=m.join(""),y("cdata",d,h,{tagName:f,attrs:u}),f=null,u=void 0,m=[]),f))if(f)m.push(i[0]);else if(l=i[4]){o=[];const e=i[5];let t,a=0;for(;t=r.exec(e);){const e=t[1],r=t[2]?t[2]:t[4]?t[4]:"",n=t[3]?t[3]:t[5]?t[5]:t[6]?t[6]:"";o.push({name:e,value:n,quote:r,index:t.index,raw:t[0]}),a+=t[0].length}a===e.length?(y("tagstart",i[0],s,{tagName:l,attrs:o,close:i[6]}),v()&&(f=l,u=o.concat(),m=[],h=c)):y("text",i[0],s)}else(i[2]||i[3])&&y("comment",i[0],s,{content:i[2]||i[3],long:!!i[2]});else y("tagend",i[0],s,{tagName:l});e.length>c&&(d=e.substring(c,e.length),y("text",d,c)),this.fire("end",{pos:c,line:g,col:e.length-p+1})}addListener(e,t){const a=this._listeners,r=e.split(/[,\s]/);let n;for(let e=0,i=r.length;e<i;e++)n=r[e],void 0===a[n]&&(a[n]=[]),a[n].push(t)}fire(e,t){void 0===t&&(t={}),t.type=e;let a=[];const r=this._listeners[e],n=this._listeners.all;void 0!==r&&(a=a.concat(r)),void 0!==n&&(a=a.concat(n));const i=this.lastEvent;null!==i&&(delete i.lastEvent,t.lastEvent=i),this.lastEvent=t;for(let e=0,r=a.length;e<r;e++)a[e].call(this,t)}removeListener(e,t){const a=this._listeners[e];if(void 0!==a)for(let e=0,r=a.length;e<r;e++)if(a[e]===t){a.splice(e,1);break}}fixPos(e,t){const a=e.raw.substr(0,t).split(/\r?\n/),r=a.length-1;let n,i=e.line;return r>0?(i+=r,n=a[r].length+1):n=e.col+t,{line:i,col:n}}getMapAttrs(e){const t={};let a;for(let r=0,n=e.length;r<n;r++)a=e[r],t[a.name]=a.value;return t}}),r);e.HTMLParser=a.default;const s=(n||(n=1,Object.defineProperty(i,"__esModule",{value:!0}),i.default=class{constructor(e,t,a={}){this.html=e,this.lines=e.split(/\r?\n/);const r=/\r?\n/.exec(e);this.brLen=null!==r?r[0].length:0,this.ruleset=t,this.messages=[],this.disabledRulesMap=a}info(e,t,a,r,n){this.report("info",e,t,a,r,n)}warn(e,t,a,r,n){this.report("warning",e,t,a,r,n)}error(e,t,a,r,n){this.report("error",e,t,a,r,n)}report(e,t,a,r,n,i){const s=this.disabledRulesMap[a];if(s){if(!0===s.all)return;if(s.rules&&s.rules.has(n.id))return}const l=this.lines,o=this.brLen;let u="",d=0;for(let e=a-1,t=l.length;e<t&&(u=l[e],d=u.length,r>d&&a<t);e++)a++,1!==(r-=d)&&(r-=o);this.messages.push({type:e,message:t,raw:i,evidence:u,line:a,col:r,rule:{id:n.id,description:n.description,link:`https://htmlhint.com/rules/${n.id}`}})}}),i);e.Reporter=s.default;const l=Ve();function o(e,t){return new Array(e+1).join(" ")}e.HTMLRules=l,e.HTMLHint=new class{constructor(){this.rules={},this.defaultRuleset={"tagname-lowercase":!0,"attr-lowercase":!0,"attr-value-double-quotes":!0,"doctype-first":!0,"tag-pair":!0,"spec-char-escape":!0,"id-unique":!0,"src-not-empty":!0,"attr-no-duplication":!0,"title-require":!0}}addRule(e){this.rules[e.id]=e}verify(e,t=this.defaultRuleset){0===Object.keys(t).length&&(t=this.defaultRuleset),e=e.replace(/^\s*<!--\s*htmlhint\s+([^\r\n]+?)\s*-->/i,((e,a)=>(a.replace(/(?:^|,)\s*([^:,]+)\s*(?:\:\s*([^,\s]+))?/g,((e,a,r)=>(t[a]=!(void 0!==r&&r.length>0)||JSON.parse(r),""))),"")));const r=this.parseDisableComments(e),n=new a.default,i=new s.default(e,t,r),l=this.rules;let o;for(const e in t)o=l[e],void 0!==o&&!1!==t[e]&&o.init(n,i,t[e]);return n.parse(e),i.messages}parseDisableComments(e){var t;const a={},r=e.split(/\r?\n/),n=/<!--\s*htmlhint-(disable|enable)(?:-next-line)?(?:\s+([^\r\n]+?))?\s*-->/gi,i=[];let s;for(;null!==(s=n.exec(e));){const a=e.substring(0,s.index).split(/\r?\n/).length,r=s[1].toLowerCase(),n=s[0].includes("-next-line"),l=null===(t=s[2])||void 0===t?void 0:t.trim();i.push({line:a,command:r,isNextLine:n,rulesStr:l})}let l=null,o=!1;for(let e=0;e<r.length;e++){const t=e+1,r=i.find((e=>e.line===t));if(r)if("disable"===r.command)if(r.isNextLine){const e=t+1;if(r.rulesStr){const t=r.rulesStr.split(/\s+/).filter((e=>e.length>0));a[e]||(a[e]={}),a[e].rules||(a[e].rules=new Set),t.forEach((t=>a[e].rules.add(t)))}else a[e]||(a[e]={}),a[e].all=!0}else if(r.rulesStr){const e=r.rulesStr.split(/\s+/).filter((e=>e.length>0));l=new Set(e),o=!1}else l=null,o=!0;else"enable"===r.command&&(l=null,o=!1);(null!==l||o)&&(a[t]||(a[t]={}),o&&!0!==a[t].all?a[t].all=!0:l&&(a[t].rules||(a[t].rules=new Set),l.forEach((e=>a[t].rules.add(e)))))}return a}format(e,t={}){const a=[],r={white:"",grey:"",red:"",reset:""};t.colors&&(r.white="[37m",r.grey="[90m",r.red="[31m",r.reset="[39m");const n=t.indent||0;return e.forEach((e=>{let t=e.evidence;const i=e.line,s=e.col,l=t.length;let u=s>41?s-40:1,d=t.length>s+60?s+60:l;s<41&&(d+=40-s+1),t=t.replace(/\t/g," ").substring(u-1,d),u>1&&(t=`...${t}`,u-=3),d<l&&(t+="..."),a.push(`${r.white+o(n)}L${i} |${r.grey}${t}${r.reset}`);let c=s-u;const f=t.substring(0,c).match(/[^\u0000-\u00ff]/g);null!==f&&(c+=f.length),a.push(`${r.white+o(n)+o(String(i).length+3+c)}^ ${r.red}${e.message} (${e.rule.id})${r.reset}`)})),a}},Object.values(l).forEach((t=>{e.HTMLHint.addRule(t)}))}(a)),a);return e(Fe)}));
