"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const promises_1 = require("node:fs/promises");
const node_fs_1 = __importDefault(require("node:fs"));
const node_os_1 = __importDefault(require("node:os"));
const node_path_1 = __importDefault(require("node:path"));
// @ts-ignore
const package_json_1 = require("../package.json");
const args_1 = require("./args");
const service_1 = require("./service");
const get_stdin_1 = __importDefault(require("./get-stdin"));
const coredCommands = ["restart", "start", "status"];
function processArgs(args) {
    const flagsToAction = {
        "--version": "PRINT_VERSION",
        "--help": "PRINT_HELP",
        "--debug-info": "PRINT_DEBUG_INFO",
        stop: "STOP",
    };
    for (const arg of args) {
        const action = flagsToAction[arg];
        if (action) {
            return [action, ""];
        }
    }
    return ["INVOKE_CORE_D", args[0]];
}
function printDebugInfo(debugInfo) {
    if (debugInfo.resolvedPrettier) {
        console.log(`prettier version: ${debugInfo.resolvedPrettier.module.version}
  Loaded from: ${debugInfo.resolvedPrettier.filePath}\n`);
    }
}
function getRuntimeDir() {
    var _a, _b;
    const baseDir = (_b = (_a = process.env.XDG_RUNTIME_DIR) !== null && _a !== void 0 ? _a : process.env.TMPDIR) !== null && _b !== void 0 ? _b : node_os_1.default.homedir();
    const basename = node_path_1.default.basename(baseDir);
    return basename === "prettierd" || basename === ".prettierd"
        ? baseDir
        : node_path_1.default.join(baseDir, ".prettierd");
}
async function verifyRuntimeDir(dir) {
    try {
        await (0, promises_1.mkdir)(dir, { recursive: true });
        await (0, promises_1.access)(dir, node_fs_1.default.constants.W_OK);
    }
    catch (e) {
        throw new Error(`failed to start prettierd, make sure ${dir} is writable ${e}`);
    }
}
async function main(args) {
    const [action, cmdOrFilename] = processArgs(args);
    switch (action) {
        case "PRINT_VERSION":
            console.log(`prettierd ${package_json_1.version}\n`);
            return;
        case "PRINT_HELP":
            (0, args_1.displayHelp)();
            return;
        case "PRINT_DEBUG_INFO":
            console.log(`prettierd ${package_json_1.version}`);
            const debugInfo = await (0, service_1.getDebugInfo)(process.cwd(), args.slice(1));
            printDebugInfo(debugInfo);
            return;
    }
    const title = "prettierd";
    const runtimeDir = getRuntimeDir();
    await verifyRuntimeDir(runtimeDir);
    process.env.XDG_RUNTIME_DIR = runtimeDir;
    process.env.CORE_D_TITLE = title;
    process.env.CORE_D_SERVICE = require.resolve("./service");
    process.env.CORE_D_DOTFILE = `.${title}@${encodeURIComponent(process.cwd())}`;
    if (action === "STOP") {
        await (0, service_1.stopAll)(runtimeDir, `.${title}`);
        return;
    }
    const core_d = require("core_d");
    if (coredCommands.includes(cmdOrFilename)) {
        core_d[cmdOrFilename]();
        return;
    }
    if (cmdOrFilename === "stop-local") {
        core_d.stop();
        return;
    }
    core_d.invoke({
        args,
        clientEnv: Object.keys(process.env)
            .filter((key) => key.startsWith("PRETTIERD_"))
            .reduce((acc, key) => Object.assign(acc, { [key]: process.env[key] }), {}),
    }, await (0, get_stdin_1.default)());
}
main(process.argv.slice(2)).catch((err) => {
    console.error(err);
    process.exit(1);
});
