"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getDebugInfo = getDebugInfo;
exports.stopAll = stopAll;
exports.invoke = invoke;
const node_path_1 = __importDefault(require("node:path"));
const node_util_1 = require("node:util");
const promises_1 = require("node:fs/promises");
const toCamelcase = (str) => str.replace(/-./g, (s) => s[1].toUpperCase());
function argsToOptions(args) {
    const options = {
        configPrecedence: "cli-override",
    };
    for (const arg of args) {
        let [key, ...valueParts] = arg.replace(/^-+/, "").split("=");
        let value = valueParts.join("=");
        if (!value.length) {
            value = !key.startsWith("no-");
            if (!value) {
                key = key.slice(3);
            }
        }
        else if (/^\d+$/.test(value)) {
            value = Number(value);
        }
        else if (/^(true|false)$/.test(value)) {
            value = value === "true";
        }
        options[toCamelcase(key)] = value;
    }
    return options;
}
async function tryToResolveConfigFromEnvironmentValue(prettier, editorconfig, value) {
    if (value) {
        return prettier.resolveConfig(node_path_1.default.dirname(value), {
            config: value,
            editorconfig,
            useCache: false,
        });
    }
    return null;
}
async function resolveConfig(env, prettier, filepath, { config, editorconfig = true }) {
    if (config === false) {
        return null;
    }
    let prettierConfig = await prettier.resolveConfig(filepath, {
        editorconfig,
        useCache: false,
    });
    if (!prettierConfig) {
        prettierConfig = await tryToResolveConfigFromEnvironmentValue(prettier, editorconfig, env.PRETTIERD_DEFAULT_CONFIG);
    }
    return prettierConfig;
}
async function resolvePrettier(env, filePath) {
    let path;
    try {
        path = require.resolve("prettier", { paths: [filePath] });
    }
    catch (e) {
        if (env.PRETTIERD_LOCAL_PRETTIER_ONLY) {
            return undefined;
        }
        path = require.resolve("prettier");
    }
    return Promise.resolve(`${path}`).then(s => __importStar(require(s))).then((v) => {
        if (v !== undefined) {
            return {
                module: v,
                filePath: path,
            };
        }
        return undefined;
    });
}
function resolveFile(cwd, fileName) {
    if (node_path_1.default.isAbsolute(fileName)) {
        return fileName;
    }
    return node_path_1.default.join(cwd, fileName);
}
const defaultCLIArguments = {
    noColor: false,
    ignorePath: ".prettierignore",
};
function parseCLIArguments(args) {
    const parsedArguments = { ...defaultCLIArguments };
    let fileName = null;
    let task = "format";
    const optionArgs = [];
    const argsIterator = args[Symbol.iterator]();
    for (const arg of argsIterator) {
        if (arg.startsWith("-")) {
            switch (arg) {
                case "--no-color":
                    parsedArguments.noColor = true;
                    break;
                case "--ignore-path": {
                    const nextArg = argsIterator.next();
                    if (nextArg.done) {
                        throw new Error("--ignore-path option expects a file path");
                    }
                    parsedArguments.ignorePath = nextArg.value;
                    break;
                }
                case "--check": {
                    task = "check";
                    break;
                }
                case "--format": {
                    task = "format";
                    break;
                }
                default: {
                    optionArgs.push(arg);
                }
            }
        }
        else {
            if (fileName) {
                throw new Error("Only a single file path is supported");
            }
            // NOTE: positional arguments are assumed to be file paths
            fileName = arg;
        }
    }
    if (!fileName) {
        throw new Error("File name must be provided as an argument");
    }
    return [parsedArguments, fileName, task, argsToOptions(optionArgs)];
}
async function run(cwd, { args, clientEnv }, text) {
    const [{ ignorePath }, fileName, task, { config, configPrecedence, editorconfig, ...cliOptions },] = parseCLIArguments(args);
    const env = { ...process.env, ...clientEnv };
    const fullPath = resolveFile(cwd, fileName);
    const resolvedPrettier = await resolvePrettier(env, node_path_1.default.dirname(fullPath));
    if (!resolvedPrettier) {
        return text;
    }
    const { module: prettier } = resolvedPrettier;
    const { ignored } = await prettier.getFileInfo(fileName, { ignorePath });
    if (ignored) {
        return text;
    }
    const fileOptions = await resolveConfig(env, prettier, fullPath, {
        config,
        editorconfig,
    });
    const options = configPrecedence === "prefer-file" && fileOptions !== null
        ? fileOptions
        : configPrecedence === "file-override"
            ? { ...cliOptions, ...fileOptions }
            : { ...fileOptions, ...cliOptions };
    switch (task) {
        case "format":
            return await prettier.format(text, {
                ...options,
                filepath: fullPath,
            });
        case "check":
            const valid = await prettier.check(text, {
                ...options,
                filepath: fullPath,
            });
            if (!valid)
                throw `Invalid formatting: ${fullPath}`;
            return "";
    }
}
async function getDebugInfo(cwd, args) {
    const [_, fileName] = parseCLIArguments(args);
    const fullPath = resolveFile(cwd, fileName);
    const resolvedPrettier = await resolvePrettier(process.env, fullPath);
    return { resolvedPrettier };
}
async function stopAll(runtimeDir, prefix) {
    const files = await (0, promises_1.readdir)(runtimeDir);
    const coredFiles = files.filter((file) => file.startsWith(prefix));
    // this is horrible
    for (const file of coredFiles) {
        process.env.CORE_D_DOTFILE = file;
        const core_d = require("core_d");
        const stop = (0, node_util_1.promisify)(core_d.stop);
        await stop();
        // core_d will cache the value of CORE_D_DOTFILE, so we have to clear the
        // cache.
        //
        // Alternatively, we could read the file and submit the stop command over
        // TCP, but let's keep this horrible approach for now.
        for (const key of Object.keys(require.cache)) {
            if (key.includes("/core_d/")) {
                delete require.cache[key];
            }
        }
        console.log(`stopped ${file}`);
    }
}
function invoke(cwd, args, text, cb) {
    if (Array.isArray(args)) {
        args = { ...args[1], args: [args[0], ...args[1].args] };
    }
    run(cwd, args, text)
        .then((resp) => void cb(undefined, resp))
        .catch((error) => void cb(error));
}
